-- Type: rs_tab_desc_prod_familia
drop function if exists ufd_est_prod_tbl_desc_qtde_familia (integer, integer, integer, integer);

DROP TYPE if exists public.rs_tab_desc_prod_familia;

CREATE TYPE rs_tab_desc_prod_familia AS
(
    cd_tbl_desc integer,
    tp_desc integer,
    flag_desc_fix integer,
    perc_desc double precision,
    perc_desc_max double precision,
    tp_nivel integer,
    ds_tp_desc character varying(100),
    qtde_pag_agr integer,
    multiplos integer
);
/*
ALTER TYPE public.rs_tab_desc_prod_familia
    OWNER TO postgres;
GRANT USAGE ON TYPE public.rs_tab_desc_prod_familia TO PUBLIC;
GRANT USAGE ON TYPE public.rs_tab_desc_prod_familia TO postgres;
*/
/*
--<<INICIO DO CORPO DA FUNCAO
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20221106
'Job.................:  
'Nome................:  ufd_est_prod_tbl_desc_qtde_familia
'Objetivo............: RETORNAR DESCONTOS DO PRODUTO EM TABELA DE DESCONTO
'Tabelas.............: 
'Dt Criação..........: 
'Dt Ult Alteracão....: 2022-11-06
'Alterado por........: Marcos barros
'Criado por..........: FERNANDO JUNIO CUNHA E SOUSA 
'=======================================================================================   
-- Function: public.ufd_est_prod_tbl_desc_qtde_familia(integer, integer, integer, integer)
-- DROP FUNCTION public.ufd_est_prod_tbl_desc_qtde_familia(integer, integer, integer, integer);
*/
CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_qtde_familia(
    integer,
    integer,
    integer,
    integer)
  RETURNS SETOF rs_tab_desc_prod_familia AS
$BODY$
 --<<INICIO DO CORPO DA FUNCAO
-- Function: select * from ufd_est_prod_tbl_desc_qtde_familia(2, 0, 1238,  3)
--DECLARA AS VARIAVEIS USADAS NA FUNCAO
DECLARE
---------------------------------------------------------
----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
int_cd_filial           ALIAS FOR $1;
int_cd_cli              ALIAS FOR $2;
int_cd_familia          ALIAS FOR $3;
int_qtde_produto        ALIAS FOR $4;
---------------------------------------------------------
---FIM
---------------------------------------------------------
vr_tp_cliente integer ARRAY;
vr_cli_conv integer;
vr_cli_cred integer;
returnRec rs_tab_desc_prod_familia; --RECEBERA OS DADOS DE RETORNO DA FUNCAO
int_cd_emp integer = 1;
var_desc_multiplo   integer;
--DECLARANDO VARIAVEL PARA TESTE DA FLAG 
BEGIN --INICIO DOS BLOCOS DA FUNCAO
    vr_tp_cliente = ARRAY [0]; -- 0 COMUM, 1 CONVENIO, 2 CREDIARIO , 3 CREDIARIO E CONVNEIO
    vr_cli_conv = 0; -- 0 false 1 true
    vr_cli_cred = 0; -- 0 false 1 true
    -------------------------------------------------------------------------------------------------------------------------------
    --DECLARANDO TABELA TEMPORARIA DE RETORNO
    -------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        CREATE TEMPORARY TABLE temp_rs_tab_desc_qtde_familia
        (
            cd_tbl_desc         integer,
            tp_desc             integer,
            flag_desc_fix       integer,
            perc_desc           double precision,
            perc_desc_max       double precision,
            tp_nivel            integer,
            dt_ini              timestamp without time zone,
            qtde_pag            integer,
            multiplos           integer,
            agregacao           integer
        );
        EXCEPTION WHEN OTHERS THEN
        TRUNCATE TABLE temp_rs_tab_desc_qtde_familia; -- TRUNCA A TABELA SE ELA JÁ EXISTIR NA CORRENTE SESSÃO.
    END;
    -------------------------------------------------------------------------------------------------------------------------------
    --DECLARANDO TABELA QUE RECEBERA AS TBLS VIGENTES
    -------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        CREATE TEMPORARY TABLE rs_tab_ativa
        (
            cd_emp      integer,
            cd_tbl_desc integer,
            tp_desc     integer
        );
        EXCEPTION WHEN OTHERS THEN
        TRUNCATE TABLE rs_tab_ativa; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
    END;
    BEGIN
        CREATE TEMPORARY TABLE rs_tab_qtde_ativa
        (
            cd_emp              integer,
            cd_tbl_desc_qtde    integer,
            tp_desc             integer
        );
        EXCEPTION WHEN OTHERS THEN
        TRUNCATE TABLE rs_tab_qtde_ativa; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
    END;
    ------------------------------------------------------------------------------------------------------------------------------- 
    ---------------------------------------------------FIM DA CRIACAO DAS TBLS TEMPORARIAS-----------------------------------------
    -------------------------------------------------------------------------------------------------------------------------------
    -- verificando se cliente e um cliente conveniado
    vr_cli_conv = COALESCE((SELECT 1 FROM rc_cli_conv_rc_cli WHERE int_cd_cli = cd_cli and sts_cred = 0 and sts_ativo = 0 LIMIT 1), 0);
    -- verificando se cliente e um cliente crediario
    vr_cli_cred = COALESCE(
                        (SELECT 1
                           FROM rc_cli c inner join rc_cli_crediario cr on
                                c.cd_cli = cr.cd_cli
                          WHERE int_cd_cli = c.cd_cli and
                                c.flag_cliente_crediario = 0 and
                                cr.sts_cred = 0 and
                                COALESCE(cr.cd_mot_bloq_cli, 0) = 0), 0);
    -- avaliando tipo de cliente
    IF vr_cli_conv = 1 THEN 
        vr_tp_cliente = ARRAY[0,1,3]; -- cliente eh convenio
        IF vr_cli_cred = 1 THEN
            vr_tp_cliente = ARRAY[0,1,2,3]; -- cliente eh crediario e convenio
        END IF;
    ELSE
        IF vr_cli_cred = 1 THEN
            vr_tp_cliente = ARRAY[0,2,3]; -- cliente eh crediario
        END IF;
    END IF;
    -- TODAS AS TABELAS QUE NAO EXITE RECEITA
    INSERT INTO rs_tab_ativa    
        SELECT  a.cd_emp,
                a.cd_tbl_desc,
                a.cd_tp_desconto
        FROM est_prod_tbl_desc a  INNER JOIN
             est_prod_tbl_desc_prc_filial fil ON
                a.cd_emp = fil.cd_emp AND
                a.cd_tbl_desc = fil.cd_tbl_desc
        WHERE   int_cd_emp = a.cd_emp AND
                int_cd_filial = fil.cd_filial AND
                1 = a.sts_tbl_desc AND
                14 = a.cd_tp_desconto;
    IF EXISTS (SELECT 1 FROM rs_tab_ativa) THEN
        -------------------------------------------------------------------------------------------------------------------------------    
        --CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
        -------------------------------------------------------------------------------------------------------------------------------    
        INSERT INTO temp_rs_tab_desc_qtde_familia     
            SELECT
                a.cd_tbl_desc AS cd_tbl_desc,
                a.cd_tp_desconto AS tp_desc,
                1 flag_desc_fix,
                b.perc_desc AS perc_desc,
                b.perc_desc_max AS perc_desc_max,
                2 AS tp_nivel,
                a.dt_ini,
                0,
                a.flag_aplica_desconto_qtde_multiplo,
                a.flag_agregar_desc_qtde_aos_descontos_existentes            
            FROM est_prod_tbl_desc a
                    INNER JOIN est_prod_tbl_desc_qtde_acima e ON
                        a.cd_emp = e.cd_emp AND
                        a.cd_tbl_desc = e.cd_tbl_desc
                    INNER JOIN est_prod_tbl_desc_est_arv_merc_familia b ON
                        a.cd_emp = b.cd_emp AND
                        a.cd_tbl_desc = b.cd_tbl_desc    
                    INNER JOIN est_prod_tbl_desc_prc_filial fil ON
                        a.cd_emp = fil.cd_emp AND
                        a.cd_tbl_desc = fil.cd_tbl_desc    
                    INNER JOIN rs_tab_ativa ON
                        a.cd_emp = rs_tab_ativa.cd_emp AND
                        a.cd_tbl_desc = rs_tab_ativa.cd_tbl_desc        
            WHERE   int_cd_familia = b.cd_arv_merc_familia and
                    int_cd_filial = fil.cd_filial and
                    int_qtde_produto >= e.qtde_acima and
                    e.tp_cliente in ( select * from unnest(vr_tp_cliente))
                    ORDER BY a.dt_ini  DESC, b.perc_desc DESC LIMIT 1;
    END IF;--IF EXISTS (SELECT 1 FROM rs_tab_ativa) THEN
    INSERT INTO rs_tab_qtde_ativa    
                SELECT  a.cd_emp,
                        a.cd_tbl_desc_qtde,
                        a.cd_tp_desconto    
                FROM est_prod_tbl_desc_qtde a INNER JOIN
                     est_prod_tbl_desc_qtde_prc_filial fil ON
                        a.cd_emp = fil.cd_emp AND
                        a.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde 
                WHERE  int_cd_emp = a.cd_emp AND
                       int_cd_filial = fil.cd_filial AND
                       CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
                       a.sts_tbl_desc = 1 AND
                       a.cd_tp_desconto = 24 AND
                       a.qtde_leve <= int_qtde_produto;
    IF EXISTS (SELECT 1 FROM rs_tab_qtde_ativa) THEN
        INSERT INTO temp_rs_tab_desc_qtde_familia     
                SELECT  cd_tbl_desc,
                        tp_desc,
                        flag_desc_fix,
                        round((1-(CAST(qtde_pag AS numeric)/int_qtde_produto))*100,2) perc_desc ,
                        round((1-(CAST(qtde_pag AS numeric)/int_qtde_produto))*100,2) perc_desc_max,
                        tp_nivel,
                        dt_ini,
                        case when agregacao = 1 then qtde_pag else 0 end qtde_pag FROM (
                SELECT
                        a.cd_tbl_desc_qtde AS cd_tbl_desc,
                        a.cd_tp_desconto AS tp_desc,
                        1 flag_desc_fix,
                        (abs(int_qtde_produto / a.qtde_leve) * a.qtde_pague) + (int_qtde_produto - (abs(int_qtde_produto / a.qtde_leve) * a.qtde_leve)) as qtde_pag,
                        2 AS tp_nivel,
                        a.dt_ini ,
                        a.agregacao
                FROM est_prod_tbl_desc_qtde a    
                        INNER JOIN est_prod_tbl_desc_qtde_est_arv_merc_familia b ON
                            a.cd_emp = b.cd_emp AND
                            a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
                        INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON
                            b.cd_emp = fil.cd_emp AND
                            b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
                        INNER JOIN rs_tab_qtde_ativa atv ON
                            a.cd_emp = atv.cd_emp AND
                            b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
                WHERE    int_cd_familia = b.cd_arv_merc_familia and
                    fil.cd_filial = int_cd_filial) AS TP
                    ORDER BY dt_ini  DESC,  perc_desc DESC LIMIT 1;
    END IF;
    var_desc_multiplo   = (select multiplos 
                             from temp_rs_tab_desc_qtde_familia 
                            where tp_desc = 14
                             ORDER BY dt_ini DESC, perc_desc DESC LIMIT 1
                           );
    -------------------------------------------------------------------------------------------------------------------------------
    -- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
    -------------------------------------------------------------------------------------------------------------------------------
/*  FOR returnRec IN 
        SELECT  cd_tbl_desc, 
                tp_desc, 
                flag_desc_fix, 
                perc_desc, 
                perc_desc_max, 
                tp_nivel, 
                (SELECT ufd_descricao_desc FROM ufd_descricao_desc(tp_desc,cd_tbl_desc,2)), 
                qtde_pag
          FROM temp_rs_tab_desc_qtde_familia 
         ORDER BY dt_ini DESC, perc_desc DESC LIMIT 1
    LOOP
        RETURN NEXT returnRec;
    END LOOP;               
END; --FIM DOS BLOCOS DA FUNCAO
*/
if var_desc_multiplo = 1  then 
    -------------------------------------------------------------------------------------------------------------------------------
    -- retornando desconto limite (resultado da funcao)
    -------------------------------------------------------------------------------------------------------------------------------
    for returnrec in
        select a.cd_tbl_desc,
               a.tp_desc,
               a.flag_desc_fix,
               (((cast(int_qtde_produto as integer ) - (cast(int_qtde_produto as integer ) % e.qtde_acima))) * a.perc_desc) / (cast(int_qtde_produto as integer )) perc_desc_mult,
               (((cast(int_qtde_produto as integer ) - (cast(int_qtde_produto as integer ) % e.qtde_acima))) * a.perc_desc_max) / (cast(int_qtde_produto as integer )) perc_desc_max_mult,
               a.tp_nivel,
               (SELECT ufd_descricao_desc FROM ufd_descricao_desc(a.tp_desc,a.cd_tbl_desc,2)),
               a.agregacao,
               a.multiplos
        FROM temp_rs_tab_desc_qtde_familia a
               inner join est_prod_tbl_desc_qtde_acima e on a.cd_tbl_desc = e.cd_tbl_desc
         where a.multiplos  = 1
         ORDER BY dt_ini DESC, perc_desc DESC LIMIT 1
   loop
        return next returnrec;
    end loop;
else 
    for returnrec in
        SELECT  cd_tbl_desc,
                tp_desc,
                flag_desc_fix,
                perc_desc,
                perc_desc_max,
                tp_nivel,
                (SELECT ufd_descricao_desc FROM ufd_descricao_desc(tp_desc,cd_tbl_desc,2)),
                qtde_pag,
                COALESCE(multiplos,0) AS multiplos
          FROM temp_rs_tab_desc_qtde_familia a
         where COALESCE(a.multiplos,0)  = 0
         ORDER BY dt_ini DESC, perc_desc DESC LIMIT 1
         loop
        return next returnrec;
    end loop;
end if;
end; --fim dos blocos da funcao
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION public.ufd_est_prod_tbl_desc_qtde_familia(integer, integer, integer, integer)
  OWNER TO postgres;